package net.xdevelop.taglib.page;

import javax.servlet.jsp.tagext.*;
import javax.servlet.jsp.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import java.net.URLEncoder;
import java.io.IOException;
import net.xdevelop.util.*;


/**
 * ҳܱ
 * ӱлȫ,Ա沢ԶɶӦ<input type=hidden>
 * ͨ㵱ǰҳ,,Լÿҳ¼,ṩʼ¼,ÿҳʾ¼,
 * ڵĳʾʼļ¼λú,;ת󷵻,ֱӵøҳ漴
 * ָԭתʱ.ҳųΧ,Զӽĺֵ.
 * ʹþ:
 * <pre>
 *  <code>
 *    int count=getCount();//ü¼
 *    condition=request.getParameter("condition");
 *    <page:pager total=<%=count%> defaultPageSize='20'>
 *      <%
 *        showRecord(condition,index,pageSize);
 *      %>
 *      <page:navigator type='BUTTON'/>
 *    </page:pager>
 *  </code>
 * <pre>
 */
public class PagerTag extends BodyTagSupport {
    private StringBuffer output;        //
    private int pageNo;                 //ǰҳ
    private int pageSize;               //ÿҳ¼
    private int index = 1;              //ʼ¼,ȱʡΪ0
    private int pages;                  //ҳ
    private String queryString;         //ҳϢ贫ݵֵ
    private String prevPage;            //ǰһҳURLqueryString
    private String nextPage;            //һҳURLqueryString
    private String currentPage;         //ǰҳURLqueryString
    private String firstPage;           //һҳURLqueryString
    private String lastPage;            //ҳURLqueryString
    private boolean resume = false;     //Ƿǻָ
    private int total = 0;              //¼,Ҫҳʾļ¼,ʼĬΪ0
    private int defaultPageSize = 20;   //ȱʡÿҳ¼,ڵиıÿҳ¼ֵ

    public void setTotal(int newTotal) {
        total = newTotal;
    }

    public void setDefaultPageSize(int newDefaultPageSize) {
        defaultPageSize = newDefaultPageSize;
    }

    /**
     * handlerзҳ
     */
    public int doStartTag() throws JspTagException {
        output = new StringBuffer();
        resume = false;
        handler();
        return EVAL_BODY_BUFFERED;
    }

    /**
     * ñڵļ¼б
     */
    public int doAfterBody() throws JspTagException {
        BodyContent bodyContent = getBodyContent();
        if (bodyContent != null) {
            output.append(bodyContent.getString());
            try {
                bodyContent.clear();
            }
            catch (IOException ex) {
                throw new JspTagException("Fatal IO Error");
            }
        }
        return SKIP_BODY;
    }

    /**
     * ڵ
     */
    public int doEndTag() throws JspTagException {
        BodyContent bodyContent = getBodyContent();
        try {
            if (bodyContent != null) {
                //
                output.append("</form>\n");
                //ȫ
                bodyContent.getEnclosingWriter().write(output.toString());
            }
        }
        catch (IOException ex) {
            throw new JspTagException("Fatal IO Error");
        }

        return EVAL_PAGE;
    }

    /**
     * ñڱ(ÿҳ¼,ǰҳ,ʼ¼,Ĳѯַ)
     */
    public void setVariable() {
        pageContext.setAttribute("pageSize", new Integer(pageSize));
        pageContext.setAttribute("pageNo", new Integer(pageNo));
        pageContext.setAttribute("total", new Integer(total));
        pageContext.setAttribute("pages", new Integer(pages));
        pageContext.setAttribute("index", new Integer(index));
    }

    /**
     * ȡҳϢеıֵ
     */
    private void handler() {
        HttpServletRequest request = (HttpServletRequest) pageContext.getRequest();
        StringBuffer paramBuf = new StringBuffer();
        HttpSession session = (HttpSession) pageContext.getSession();
        String choice = "";
        HashMap params = new HashMap();

        //õǰҳURI
        String requestURI = request.getRequestURI();

        //ȡ
        choice = ParamUtil.getParameter(request, "choice");

        //жǷת󷵻ָԭҳϢ(жݣGETʽûṩ)
        if (choice.equals("") && request.getMethod().equals("GET") && request.getQueryString() == null) {
            //Ƿҳͬ
            String pageURI = (String) session.getAttribute("pageURI");
            if (request.getRequestURI().equalsIgnoreCase(pageURI))
                resume = true;
            else
                resume = false;
        }

        if (resume) { //;ת󷵻ص
            //sessionȡ
            Object obj = session.getAttribute("pagerParameters");
            if (obj != null) {
                params = (HashMap) obj;

                //ȡÿҳ¼,ûָ,ʹĬֵ
                pageSize = ((Integer) params.get("pageSize")).intValue();

                //ȡҳ
                pageNo = ((Integer) params.get("pageNo")).intValue();
            }
            else {
                //ṩĬֵ(һGETѯҲĴ,Ϊͬתָ)
                pageSize = defaultPageSize;
                pageNo = 1;
            }

            //趨
            choice = "current"; //Ϊȡǰҳ
        }
        else {
            //ȡÿҳ¼,ûָ,ʹĬֵ
            pageSize = ParamUtil.getIntParameter(request, "pageSize", defaultPageSize);

            //ȡҳ
            pageNo = ParamUtil.getIntParameter(request, "pageNo", 1);
        }

        //ÿҳ¼Խ紦
        if (pageSize <= 0)
            pageSize = 1;

        //ҳ
        pages = (total % pageSize == 0) ? total / pageSize : total / pageSize + 1;

        //ݲ,ȷǰҳ
        if (choice.equals("next"))
            pageNo++;
        if (choice.equals("prev"))
            pageNo--;
        if (choice.equals("first"))
            pageNo = 1;
        if (choice.equals("last"))
            pageNo = pages;

        //ҳԽ紦
        if (pageNo > pages)
            pageNo = pages;
        if (pageNo <= 0)
            pageNo = 1;

        //ʼ¼
        index = (pageNo - 1) * pageSize + 1;

        //ͷ
        output.append("<form action='' method='post' name='pager'>\n");

        Enumeration enum;
        String name;
        String value;
        if (resume) { //;ת󷵻ص
            //ָsessionеĲ
            Collection co = params.entrySet();
            if (co != null) {
                Iterator it = params.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = (Map.Entry) it.next();
                    name = (String) e.getKey();
                    if (name.equals("pageNo") || name.equals("pageSize") || name.equals("choice")) { //Թ
                        continue;
                    }
                    value = (String) e.getValue();
                    paramBuf.append("<input type='hidden' name='" + name + "' value='" + value +
                                    "'>\n");
                }
            }
        }
        else {
            //ȡύĲ,ñ"<input type='hidden' name='' value=''>"
            enum = request.getParameterNames();

            while (enum.hasMoreElements()) {
                name = (String) enum.nextElement();
                value = ParamUtil.getParameter(request, name);
                //ѯֵ
                params.put(name, value);

                if (name.equals("pageNo") || name.equals("pageSize") || name.equals("choice")) {
                    continue;
                }
                paramBuf.append("<input type='hidden' name='" + name + "' value='" + value +
                                 "'>\n");
            }

            //ҳֵ
            params.put("pageNo", new Integer(pageNo));
            params.put("pageSize", new Integer(pageSize));

            //浽session
            session.setAttribute("pagerParameters", params);

            //浱ǰURI
            session.setAttribute("pageURI", request.getRequestURI());
        } ////////end of if(resume)

        //ҳ
        paramBuf.append("<input type='hidden' name='pageNo' value='" + pageNo + "'>\n");
        paramBuf.append("<input type='hidden' name='pageSize' value='" + pageSize + "'>\n");
        paramBuf.append("<input type='hidden' name='choice' value='" + choice + "'>\n");

        output.append(paramBuf.toString());
        setVariable();
        if (resume) {
            //תָύ
            String resend = "<script language='javascript'>"
                            + "document.pager.submit();"
                            + "</script>\n";
            output.append(resend);
        }
    }
}
